/*****************************************************************************
**+------------------------------------------------------------------------+**
**|                                                                        |**
**|                Copyright 2010 Mistral Solutions Pvt Ltd.               |**
**|                                                                        |**
**|                                                                        |**
**|                                                                        |**   
**| This program is free software; you can redistribute it and/or          |**
**| modify it under the terms of the GNU General Public License as         |**
**| published by the Free Software Foundation; either version 2 of         |**
**| the License, or (at your option) any later version.                    |**
**|                                                                        |**
**| This program is distributed in the hope that it will be useful,        |**
**| but WITHOUT ANY WARRANTY; without even the implied warranty of         |**
**| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the           |**
**| GNU General Public License for more details.                           |**
**|                                                                        |**      
**| You should have received a copy of the GNU General Public License      |**
**| along with this program; if not, write to the Free Software            |**
**| Foundation, Inc., 59 Temple Place, Suite 330, Boston,                  |**
**| MA 02111-1307 USA                                                      |**
**+------------------------------------------------------------------------+**
*****************************************************************************/   

/**
 * \file    ddr3.h
 *
 * \brief   Support routines for DDR test application
 *
 * This file contains the support function for DDR Test application.
 *
 * \author  0043
 *
 * \version 01a,13aug,2010 Created
 */

#ifndef _DDR_2_H_
#define _DDR_2_H_

#define DDR0_CTRL		 0
#define DDR1_CTRL		 1

#define DDR0_BASE        0x80000000  // Start of DDR0
#define DDR0_SIZE        0x20000000  // 512 MB
#define DDR1_BASE        0xC0000000  // Start of DDR1
#define DDR1_SIZE        0x20000000  // 512 MB
#define DDR_BANK_SIZE	 0x01000000  

#define DDR_MEM_BANK	8
#define DDR0_BANK_NUM	(DDR_MEM_BANK + DDR_MEM_BANK + DDR_MEM_BANK + DDR_MEM_BANK)
#define DDR1_BANK_NUM	(DDR_MEM_BANK + DDR_MEM_BANK + DDR_MEM_BANK + DDR_MEM_BANK)
#define DDR_RW_SIZE		(16 * 1024)

/* ------------------------------------------------------------------------ *
 *  DDR0 Controller                                                         *
 * ------------------------------------------------------------------------ */
#define DDR_EMIF0_BASE  0x4C000000

/* ------------------------------------------------------------------------ *
 *  DDR1 Controller                                                         *
 * ------------------------------------------------------------------------ */
#define DDR_EMIF1_BASE  0x4D000000


/* ------------------------------------------------------------------------ *
 *  Prototype                                                               *
 * ------------------------------------------------------------------------ */
void ddr3_init( );
void ddr3_read( UINT16 *pSrc, UINT16 *pDst, UINT32 length );
void ddr3_write( UINT16 *pSrc, UINT16 *pDst, UINT32 length );
#endif /* _DDR_2_H_ */
